<?php

namespace Tenweb_Builder\FastEditor\Tools;
class WriteWithAITool extends FastEditorTool
{
    private $aiActions;
    private $aiErrors;

    public string $dataAttr = 'data-write-ai-tool';

    /**
     * Variable is getting on of 3 values
     * text: for generating texts
     * image: for generating image
     * all: for generating and texts and images
    */
    public $generate_type = 'text';

    public function __construct( $controlData = [] ) {
        parent::__construct( $controlData );
        $this->setActions();
        $this->setAIErrors();
        if ( !empty($controlData) && isset($controlData[0]['generate_type']) ) {
            $this->generate_type = $controlData[0]['generate_type'];
        }
    }

    public function getToolContent() {
        $write_with_ai_html = '';
        $tooltip_button_text = ($this->generate_type === 'text') ? __('Write with ','tenweb-builder') : __('Generate with ','tenweb-builder');
        if( $this->visibilityCheck() ) {
            $actions = $this->aiActions;
            $help_active = false;
            if ( class_exists( '\Tenweb_Manager\Manager' ) ) {
                $user_info = \Tenweb_Manager\Helper::get_tenweb_user_info();
                if ( is_array($user_info) && isset($user_info['agreement_info'] ) ) {
                    if ( is_array($user_info['agreement_info']) && isset($user_info['agreement_info']['coupon_code']) && $user_info['agreement_info']['coupon_code'] === '1wf' ) {
                        $help_active = true;
                    }
                }
            }

            $help_class = $help_active ? ' twbb-help-active' : '';
            $generate_type_class = ' twbb-generatin-type-' . $this->generate_type;
            if( $this->generate_type === 'image' ) {
                $write_with_ai_html = "<div class='twbb-fe-tool twbb-fe-right-border twbb-ai-front twbb-ga-data-save twbb-fe-tool twbb-fe-tool-write_with_ai " . $help_class . $generate_type_class . " '
                data-eventName='write with AI content'  " . $this->dataAttr . "='" . esc_attr($this->controlName) . "'  data-tool='write_with_ai' data-control='twb-ai-image-button'>
                    <div class='twbb-ai-front-button-layer' data-analytics='generate with AI'>
                        <span class='twbb-ai-front-button twbb-ai-generate-image'><span class='twbb-hide-in-hover'>" . $tooltip_button_text . "</span>" . __('AI', 'tenweb-builder') . "</span>
                    </div>                
                </div>";
            } else {
                $write_with_ai_html = "<div class='twbb-fe-tool twbb-fe-right-border twbb-ai-front twbb-ga-data-save twbb-fe-tool-write_with_ai " . $help_class . $generate_type_class . " '
                data-eventName='write with AI content'  " . $this->dataAttr . "='" . esc_attr($this->controlName) . "'  data-tool='write_with_ai' data-control='write_with_ai'>
                <div class='' style='position:relative'>
                <div class='twbb-ai-front-layout' style='display: none'></div>
                <div class='twbb-ai-front-button-layer' data-analytics='write with AI'>
                    <span class='twbb-ai-front-button'><span class='twbb-hide-in-hover'>" . $tooltip_button_text . "</span>" . __('AI', 'tenweb-builder') . "</span>
                </div>
                <div  class='twbb-ai-front-action-cont'>";
                if ( $this->generate_type === "all" ) {
                    $write_with_ai_html .= "<div class='twbb-ai-generate-image twbb-ai-generate-title'>" . __('Generate image', 'tenweb-builder') . "</div><hr>
                                        <div class='twbb-ai-generate-text twbb-ai-generate-title'>" . __('Write text', 'tenweb-builder') . "</div>";
                }
                $write_with_ai_html .= "<span class='twbb-a-front-suggested-propmt twbb-ai-front-simplify_language twbb-ai-action-button' data-action='" . $actions['simplify_language']['endpoint'] . "'>
                        <span class='twbb-ai-front-loader'></span>" . $actions['simplify_language']['title'] . "</span>
                    <span class='twbb-a-front-suggested-propmt twbb-ai-front-make_it_longer twbb-ai-action-button' data-action='" . $actions['make_it_longer']['endpoint'] . "'>
                        <span class='twbb-ai-front-loader'></span>" . $actions['make_it_longer']['title'] . "</span>
                    <span class='twbb-a-front-suggested-propmt twbb-ai-front-make_it_shorter  twbb-ai-action-button' data-action='" . $actions['make_it_shorter']['endpoint'] . "'>
                        <span class='twbb-ai-front-loader'></span>" . $actions['make_it_shorter']['title'] . "</span>
                    <span class='twbb-a-front-suggested-propmt twbb-ai-front-fix_spelling twbb-ai-action-button' data-action='" . $actions['fix_spelling_and_grammar']['endpoint'] . "'>
                        <span class='twbb-ai-front-loader'></span>" . $actions['fix_spelling_and_grammar']['title'] . "</span>
                    <hr>
                    <span class='twbb-a-front-suggested-propmt twbb-ai-front-new_prompt twbb-ai-front-new-prompt-button'><span class='twbb-ai-front-loader'></span>" . __('New prompt', 'tenweb-builder') . "</span>
                </div>
                <div class='twbb-ai-front-new_prompt-container'>
                    <div class='twbb-ai-front-new_prompt-title'>" . $actions['new_prompt']['title'] . "</div>
                    <textarea class='twbb-ai-front-new_prompt-textarea' placeholder='" . __('Describe the text and tone you want to use…', 'tenweb-builder') . "'></textarea>
                    <div class='twbb-ai-front-new_prompt-action-button twbb-ai-front-button-disabled' data-action='" . $actions['new_prompt']['endpoint'] . "'>
                    <span class='twbb-ai-front-loader'></span>
                    <span class='twbb-ai-front-new_prompt-action-button-text'>" . __('Generate Text', 'tenweb-builder') . "</span>
                </div>
                </div>
                </div>
                </div>";
            }
        }

        return $write_with_ai_html;

    }

    public function editorScripts() {}

    public function frontendScripts() {
        wp_enqueue_script( 'twbb-write-with-ai-helper-js', TWBB_URL . '/Apps/TextGenerationAI/assets/js/write_with_ai_helper.js', [ 'jquery' ], TWBB_VERSION, TRUE );
        wp_enqueue_script( 'twbb-write-with-ai-js', TWBB_URL . '/Apps/FastEditor/assets/scripts/write_with_ai_frontend.js', [ 'jquery','twbb-editor-helper-script', 'twbb-write-with-ai-helper-js','twbb-fe-helper-script'], TWBB_VERSION, TRUE );
    }
    public function frontendStyles() {
        wp_enqueue_style( 'twbb-write-with-ai-frontend', TWBB_URL . '/Apps/FastEditor/assets/styles/write_with_ai_frontend.css', array(), TWBB_VERSION );
    }

    protected function visibilityCheck()
    {
        if ( TW_HOSTED_ON_10WEB ) {
            return true;
        }
        return false;
    }

    public function getLocalizedData(){
        $limitation_data  = $this->getLimitationData();
        $total_allowed_words = !empty ($limitation_data['planLimit']) ? intval($limitation_data['planLimit']) : 0;
        $domain_id = get_site_option( TENWEB_PREFIX . '_domain_id' );
        $localized_write_with_ai_data = array(
            'twbb_write_with_ai_data' => array(
                'ajaxurl' => admin_url('admin-ajax.php'),
                'ajaxnonce' => wp_create_nonce('wp_rest'),
                "rest_route" => get_rest_url(null, 'ai-builder-tenweb/ai'),
                "notification_status" => get_transient('twbb_notification'),
                'limitation_expired' => $limitation_data['limitation_expired'],
                'plan' => \Tenweb_Builder\Modules\ai\Utils::is_free( $total_allowed_words ) ? 'Free' : '',
                'error_data' => $this->aiErrors,
                'domain_id' => !empty($domain_id) ? $domain_id : '',
            )
        );
        return $localized_write_with_ai_data;
    }

    private function getLimitationData() {
    $limitation = get_option('twbb_limitation');
    if ( !empty($limitation) && ($limitation['planLimit'] <= $limitation['alreadyUsed']) )  {
        return array(
            'limitation_expired'  => 1,
            'plan' => $limitation['planTitle'],
        );
    }
    return array(
        'limitation_expired'  => 0,
        'plan' => isset($limitation['planTitle']) ? $limitation['planTitle'] : __('Free', 'tenweb-builder'),
    );
}

    private function setActions() {
        $this->aiActions = array(
            'new_prompt' => array(
                'title' =>  esc_html__('New prompt','tenweb-builder'),
                'endpoint' => 'new_prompt'
            ),
            'simplify_language' => array(
                'title' =>  esc_html__('Simplify Language','tenweb-builder'),
                'endpoint' => 'simplify_language'
            ),
            'make_it_longer' => array(
                'title' =>  esc_html__('Make it longer','tenweb-builder'),
                'endpoint' => 'make_it_longer'
            ),
            'make_it_shorter' => array(
                'title' =>  esc_html__('Make it shorter','tenweb-builder'),
                'endpoint' => 'make_it_shorter'
            ),
            'fix_spelling_and_grammar' => array(
                'title' =>  esc_html__('Fix spelling & grammar','tenweb-builder'),
                'endpoint' => 'fix_spelling_and_grammar'
            ),
            'change_tone' => array(
                'title' =>  esc_html__('Change tone','tenweb-builder'),
                'endpoint' => 'change_tone'
            ),
            'translate_to' => array(
                'title' =>  esc_html__('Translate to','tenweb-builder'),
                'endpoint' => 'translate_to'
            ),
        );
    }

    private function setAIErrors() {
        $this->aiErrors = array(
            'free_limit_reached' => array(
                'text' => __('You have reached your monthly limit of Free Plan. Upgrade to a higher plan to continue using AI Assistant.', 'tenweb-builder'),
            ),
            'plan_limit_reached' => array(
                'text' => __('You have reached your monthly limit for the Personal Plan. Upgrade to a higher plan to continue using AI Assistant.', 'tenweb-builder'),
            ),
            'permission_error' => array(
                'text' => __('You cannot edit this page because you do not have the necessary permissions. Please log in with an administrator account to proceed.', 'tenweb-builder'),
            ),
            'there_is_in_progress_request' => array(
                'text' => __('It seems like another generation request is in progress. Please retry once its finished.', 'tenweb-builder'),
            ),
            'input_is_long' => array(
                'text' => __('Selected text is too long, please select a short text and try again.', 'tenweb-builder'),
            ),
            'expectation_failed' => array(
                'text' => __('Selected text is too long, please select a short text and try again.', 'tenweb-builder'),
            ),
            'something_wrong' => array(
                'text' => __('There was an issue while attempting to access 10Web services. Please try again later.', 'tenweb-builder'),
            ),
        );
    }

}