<div class="twbb-ai-popup-layout" style="display:none"></div>
<div class="twbb-ai-popup-container" style="display:none">
  <div class="twbb-ai-popup-header">
    <?php
    if ( TENWEB_WHITE_LABEL ) {
    ?>
    <span class="twbb-ai-logo-witelabel"></span>
    <?php
    } else {
    ?>
    <span class="twbb-ai-logo"></span>
    <?php } ?>
    <span class="twbb-ai-close"></span>
  </div>
  <div class="twbb-ai-popup-content twbb-ga-data-save">
    <?php twbb_ai_empty_propmpts( $this->prompts ); ?>
    <?php twbb_ai_propmpts( $this->ai_actions, $this->ai_tones, $this->ai_translates ); ?>
  </div>
  <div class="twbb-ai-loading" style="display: none"><span></span></div>
</div>

<?php
function twbb_ai_empty_propmpts( $prompts ) {
  ?>
  <div style="display: none" class="twbb-ai-suggested-propmts-container twbb-ai-propmts-empty-container">
    <input class="twbb-ai-description-input twbb-ai-text" type="text" required placeholder="<?php esc_attr_e('Describe the text and tone you want to use…','tenweb-builder'); ?>">
    <span class="twbb-ai-error-message" style="display: none"></span>
    <div class="twbb-ai-suggested-propmts-content">
      <h4 class="twbb-ai-suggested-propmts-title"><?php esc_html_e('Suggested prompts:','tenweb-builder'); ?></h4>
      <div class="twbb-ai-text-prompts" style="display: none">
        <?php foreach ( $prompts['text_prompts'] as $prompt ) { ?>
          <div class="twbb-ai-suggested-propmt-cont">
            <span class="twbb-ai-suggested-propmt twbb-ai-suggested-prompt-texts"><?php echo esc_html($prompt); ?></span>
          </div>
        <?php } ?>
      </div>
      <div class="twbb-ai-headline-prompts" style="display: none">
        <?php foreach ( $prompts['headline_prompts'] as $prompt ) { ?>
          <div class="twbb-ai-suggested-propmt-cont">
            <span class="twbb-ai-suggested-propmt twbb-ai-suggested-prompt-texts"><?php echo esc_html($prompt); ?></span>
          </div>
        <?php } ?>
      </div>
    </div>
    <div class="twbb-ai-button-container">
      <button class="twbb-ai-blue-button twbb-ai-action-button" data-action="new_prompt"><?php esc_html_e('GENERATE TEXT','tenweb-builder'); ?></button>
    </div>
  </div>
  <?php
}

function twbb_ai_propmpts( $ai_actions, $ai_tones, $ai_translates ) {
  ?>
  <div style="display: none" class="twbb-ai-suggested-propmts-container twbb-ai-propmts-result-container">
    <textarea class="twbb-ai-result-textarea twbb-ai-text"></textarea>
    <span class="twbb-ai-error-message" style="display: none"></span>
    <p class="twbb-ai-result-textarea-descr">
      <?php esc_html_e('Text generated by AI may be inaccurate or offensive.','tenweb-builder'); ?>
    </p>

    <div class="twbb-ai-suggested-propmts-content">
        <span class="twbb-ai-suggested-propmt twbb-ai-simplify_language twbb-ai-action-button" data-action="simplify_language" data-gtag=""><?php echo esc_html($ai_actions['simplify_language']['title']); ?></span>
        <span class="twbb-ai-suggested-propmt twbb-ai-make_it_longer twbb-ai-action-button" data-action="make_it_longer"><?php echo esc_html($ai_actions['make_it_longer']['title']); ?></span>
        <span class="twbb-ai-suggested-propmt twbb-ai-make_it_shorter twbb-ai-action-button" data-action="make_it_shorter"><?php echo esc_html($ai_actions['make_it_shorter']['title']); ?></span>
        <span class="twbb-ai-suggested-propmt twbb-ai-fix_spelling twbb-ai-action-button" data-action="fix_spelling_and_grammar"><?php echo esc_html($ai_actions['fix_spelling_and_grammar']['title']); ?></span>
        <hr>
        <div class="twbb-ai-tone-row">
          <?php twbb_custom_select( 'change_tone', 'Change tone', $ai_tones ); ?>
          <?php twbb_custom_select( 'translate_to', 'Translate to', $ai_translates ); ?>
        </div>
    </div>
    <div class="twbb-ai-button-container">
      <button class="twbb-ai-grey-button twbb-ai-new-prompt-button"><?php esc_html_e('NEW PROMPT','tenweb-builder'); ?></button>
      <button class="twbb-ai-blue-button twbb-ai-use-text-button"><?php esc_html_e('USE TEXT','tenweb-builder'); ?></button>
    </div>
  </div>
  <?php
}

/* Custom select/optionn */
function twbb_custom_select( $action_type, $default_title, $options = array() ) { ?>
  <div class="twbb-ai-select-container twbb-ai-select-closed">
    <div class="twbb-ai-select-value"><?php echo esc_html($default_title); ?></div>
    <div class="twbb-ai-select-options-container" style="display:none">
      <div class="twbb-ai-select-options">
        <?php foreach ($options as $option) { ?>
          <span data-value="<?php echo esc_attr(strtolower($option)); ?>" class="twbb-ai-action-button" data-action="<?php echo esc_attr($action_type); ?>">
            <?php echo esc_html($option); ?>
          </span>
        <?php } ?>
      </div>
    </div>
  </div>
<?php
}
?>
