<?php
namespace Tenweb_Builder\Widgets\Woocommerce\Products\Skins;

use Elementor\Controls_Manager;
use WC_Product_Variable;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Skin_Classic extends Skin_Base {

	protected function _register_controls_actions() {
		parent::_register_controls_actions();
    }

    public function add_injected_controls() {
        add_action( 'elementor/element/twbb_woocommerce-products/section_content/after_section_end', [ $this, 'register_hover_controls' ] );
        add_action( 'elementor/element/twbb_woocommerce-products/classic_skin_section_design_box/before_section_end', [ $this, 'inject_contrasting_controls' ] );
    }

    public function render() {
        parent::render();

    }

	public function get_id() {
		return 'classic';
	}

	public function get_title() {
		return esc_html__( 'Classic', 'tenweb-builder' );
	}

    public function get_woocommerce_product_variations() {
        global $product;
        $variations_count_to_show = 4;
        $product_variable = new WC_Product_Variable( $product->get_id() );
        $variations_all = $product_variable->get_available_variations();
        $variations = $variations_all;
        $additional = 0;
        if ( count( $variations_all ) > $variations_count_to_show ) {
            $additional = count( $variations_all ) - $variations_count_to_show;
            $variations = array_slice($variations_all, $variations_count_to_show - 1);
        }
        echo '<div class="twbb-woocommerce-products-variations">';
        foreach ( $variations as $variation ) {
            $the_variation = wc_get_product($variation['variation_id']);
            $variation_attrs = $the_variation->get_variation_attributes();
            $attrs_html = '';
            $attrs_as_params = '';
            foreach ( $variation_attrs as $attr_key => $attr_value ) {
                $attrs_html .= 'data-' . $attr_key . '="' . esc_attr($attr_value) . '"';
                $attrs_as_params .= $attr_key . '=' . $attr_value . '&';
            }
            echo '<img src="' . esc_url($variation['image']['thumb_src']) . '" ' . $attrs_html . ' data-attrs_as_params="' . esc_attr($attrs_as_params) .'">'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
        }
        if( $additional !== 0 ) {
            echo "<span class='twbb-additional-variations'>+".esc_html($additional)."</span></div>";
        } else {
            echo '</div>';
        }
    }

    protected function add_filters() {
        $settings = $this->parent->get_settings_for_display();
        // Add a wrapper class to the Add to Cart & View Items elements if the automically_align_buttons switch has been selected.
        if ( 'yes' === $settings['automatically_align_buttons'] ) {
            add_filter( 'woocommerce_loop_add_to_cart_link', [ $this->parent, 'add_to_cart_wrapper' ], 10, 1 );
        }

        //10web customization
        if ( isset( $settings[$this->get_control_id('skin_hide_products_description')]) &&
            '' === $settings[$this->get_control_id('skin_hide_products_description')] ) {
            add_action('woocommerce_after_shop_loop_item_title', array($this->parent, 'get_description_of_products'), 9);
        }
        if ( 'yes' === $settings[$this->get_control_id('skin_hide_products_buttons')] ) {
            add_filter( 'woocommerce_loop_add_to_cart_link', [ $this, 'remove_add_to_cart' ], 10, 1 );
        } else {
            if ( '' === $settings[$this->get_control_id('skin_hide_product_quantity')] ) {
                add_filter( 'woocommerce_loop_add_to_cart_link', [ $this, 'quantity_add_to_cart' ], 10, 1 );
            }
        }

        add_action( 'woocommerce_before_shop_loop_item_title', [ $this, 'get_woocommerce_product_variations'], 11 );

	    if ('yes' === $settings['slider_view']) {
		    add_filter('woocommerce_product_loop_start', array($this, 'slider_wrapper_start'));
		    add_filter('woocommerce_product_loop_end', array($this, 'slider_wrapper_end'));
		    add_filter('post_class', array($this, 'slider_item_class'));
	    }
    }

    protected function remove_added_filters() {
        $settings = $this->parent->get_settings_for_display();
        if ( 'yes' === $settings['automatically_align_buttons'] ) {
            remove_filter( 'woocommerce_loop_add_to_cart_link', [ $this->parent, 'add_to_cart_wrapper' ], 10 );
        }
        //10web customization
        if ( '' === $settings[$this->get_control_id('skin_hide_products_description')] ) {
            remove_action('woocommerce_after_shop_loop_item_title', [$this->parent, 'get_description_of_products'], 9);
        }
        if ( 'yes' === $settings[$this->get_control_id('skin_hide_products_buttons')] ) {
            remove_filter( 'woocommerce_loop_add_to_cart_link', [ $this, 'remove_add_to_cart' ], 10 );
        } else {
            if ( '' === $settings[$this->get_control_id('skin_hide_product_quantity')] ) {
                remove_filter( 'woocommerce_loop_add_to_cart_link', [ $this, 'quantity_add_to_cart' ], 10 );
            }
        }

        remove_action( 'woocommerce_before_shop_loop_item_title', [ $this, 'get_woocommerce_product_variations'], 11 );

	    if ('yes' === $settings['slider_view']) {
		    remove_filter('woocommerce_product_loop_start', array($this, 'slider_wrapper_start'));
		    remove_filter('woocommerce_product_loop_end', array($this, 'slider_wrapper_end'));
		    remove_filter('post_class', array($this, 'slider_item_class'));
	    }
    }

    public function inject_contrasting_controls() {
        $this->parent->start_injection( [
            'at' => 'after',
            'of' => 'paginate',
        ] );
        $this->add_control('skin_hide_products_images', [
            'label' => __('Hide Products Images', 'tenweb-builder'),
            'type' => Controls_Manager::SWITCHER,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}}.elementor-wc-products .attachment-woocommerce_thumbnail,
          {{WRAPPER}}.elementor-wc-products .woocommerce-placeholder' => 'display: none',
            ],
        ]);
        $this->parent->end_injection();



        $this->parent->start_injection( [
            'at' => 'after',
            'of' => 'modern_skin_description_length',
        ] );
        $this->add_control('skin_hide_products_buttons', [
            'label' => __('Hide Add to Cart buttons', 'tenweb-builder'),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'yes',
        ]);
        $this->parent->end_injection();



        $this->parent->start_injection( [
            'at' => 'after',
            'of' => 'classic_skin_box_padding',
        ] );

        $this->add_responsive_control('skin_content_padding', [
            'label' => __('Content Padding', 'tenweb-builder'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', 'em' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 50,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}}.elementor-wc-products ul.products li.product .woocommerce-loop-product__title,
		{{WRAPPER}}.elementor-wc-products ul.products li.product .star-rating,
		{{WRAPPER}}.elementor-wc-products ul.products li.product .price,
		{{WRAPPER}}.elementor-wc-products ul.products li.product .add_to_cart_button,
		{{WRAPPER}}.elementor-wc-products ul.products li.product .twbb_woocommerce-loop-product__desc,
		{{WRAPPER}}.elementor-wc-products ul.products li.product .star-rating' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
            ],
        ]);

        $this->parent->end_injection();
    }


    public function register_hover_controls() {
        $this->start_controls_section('skin__section_product_hover', [
            'label' => esc_html__('Product hover', 'tenweb-builder'),
            'tab' => Controls_Manager::TAB_CONTENT,
        ]);
        $this->add_control('skin_product_title_on_hover', [
            'label' => __('Product Title On Hover', 'tenweb-builder'),
            'type' => Controls_Manager::SWITCHER,
            'label_off' => __('Show', 'tenweb-builder'),
            'label_on' => __('Hide', 'tenweb-builder'),
            'default' => '',
            'prefix_class' => 'twbb-product-title-hide-on-hover-',
        ]);
        $this->add_control('skin_product_description_on_hover', [
            'label' => __('Products Description On Hover', 'tenweb-builder'),
            'type' => Controls_Manager::SWITCHER,
            'label_off' => __('Show', 'tenweb-builder'),
            'label_on' => __('Hide', 'tenweb-builder'),
            'default' => '',
            'prefix_class' => 'twbb-product-description-hide-on-hover-',
        ]);
        $this->end_controls_section();
    }
}
